//-------------------------------------------//
//                                           //
//           Marijus Verzbolauskas           //
//           IT, 1 gr.                       //
//                                           //
//-------------------------------------------//

#include <iostream>
#include <fstream>

using namespace std;

class data
{
    public:
        string name;
        int number;
        bool given;
        char isFree;
        double countAll;

}Data;

class ptr
{
    public:
        ptr* next;
        ptr* prev;   
};

class stack : public data, public ptr
{         
    public:
        void initialize(stack*);
        stack* push(stack*, string, int, bool, char, double);
        stack* pop(stack*);
        void stackDisplay(stack*);
        void stackDisplayReverse(stack*);
        void top(stack*);
        stack* kill(stack*);
        void save();
        stack* load(stack*);
        
        int itemsCount;

}*head, object;

int main()
{
    int ch;
    string name;
    int number;
    bool given;
    char isFree;
    double countAll;
    
    object.initialize(head);
    head = object.load(head);
    while(1)
    {
        
        cout << " " << endl;
        cout << "---------------------------------------------" << endl;
        cout << "|                                           |" << endl;
        cout << "|            Automobiliu nuoma              |" << endl;
        cout << "|                                           |" << endl;
        cout << "---------------------------------------------" << endl;
        cout << "|  MENIU                                    |" << endl;
        cout << "---------------------------------------------" << endl;
        cout << "|  1.Push                                   |" << endl;
        cout << "|  2.Pop                                    |" << endl;
        cout << "|  3.Spausdinti steka                       |" << endl;
        cout << "|  4.Spausdinti virsutini steko elementa    |" << endl;
        cout << "|  5.Istrinti steka                         |" << endl;
        cout << "|  6.Steko dydis                            |" << endl;
        cout << "|  7.Spausdinti steka atvirksciai           |" << endl;
        cout << "|                                           |" << endl;
        cout << "|  0.Iseiti                                 |" << endl;
        cout << "---------------------------------------------" << endl;\
        cout << "  " << endl;
        cin >> ch;
        system("cls");
        
        switch(ch)
        {
            case 1:
                cin.ignore(INT_MAX, '\n');
                 cout << "                              " << endl;
                 cout << "---------------------------------------------" << endl;
                 cout << "  Pavadinimas: "; getline(cin, name);
                 cout << "  Skaicius sadelyje: "; cin >> number;
                 cout << "  Ar nuomuojama? (0-ne / 1-taip): "; cin >> given;
                 cout << "  Ar yra laisvu automobiliu? (T / N): "; cin >> isFree;
                 cout << "  Buvo uzsakyta: "; cin >> countAll;
                 cout << "---------------------------------------------" << endl;
                 cout << "                              " << endl;  
                head = object.push(head, name, number, given, isFree, countAll);
                object.stackDisplay(head);
                break;
            case 2:
                head = object.pop(head);
                object.stackDisplay(head);
                break;
            case 3:
                object.stackDisplay(head);
                break;
            case 4:
                object.top(head);
                break;
            case 5:
                head = object.kill(head);
                break;
            case 6:
                cout << " " << endl;
                cout << "  Steko dydis yra: " << object.itemsCount << endl;
                break;
            case 7:
                object.stackDisplayReverse(head);
                break;
            case 0:
                object.save();
                return 0;
        }
    }
}

void stack::initialize(stack* head)
{
    head = NULL;
}

stack* stack::push(stack* head, string name, int number, bool given, char isFree, double countAll)
{
    stack* temp, *temp1;
    temp1 = head;
    temp = new stack;
    temp->name = name;
    temp->number = number;
    temp->given = given;
    temp->isFree = isFree;
    temp->countAll = countAll;
    temp->next = NULL;
    temp->prev = NULL;
    
    if(head == NULL)
    {
        head = temp;
        itemsCount++;
    }
    else
    {
        while(head->next != NULL)
        {
            head = (stack*)head->next;
        }
        head->next = temp;
        temp->prev = head;
        head = temp1;
        itemsCount++;
    }
    return head;
}

stack* stack::pop(stack* head)
{
    stack* temp;
    stack* head1;
   
    if(head != NULL)
    {
        temp = head;
        if(head->next == NULL)
        {
            cout << "  Istrintas steko elementas: " 
                 << head->name << endl;
            itemsCount--;
            return NULL;
        }

    while(head->next->next != NULL)
    {
        head = (stack*)head->next;
    }
    	head1 = (stack*)head->next;
        cout << "  Istrintas steko elementas: " 
             << head1->name << endl;
    
    head->next = head->next->next;
    delete head->next;
    
    head = temp;
    itemsCount--;
    
    return head;
    }
    else
    {
        cout << "  Stekas yra tuscias\n";
        return head;
    }
}

void stack::stackDisplayReverse(stack* head)
{
    if(head != NULL)
    {
        while(head != NULL)
        {
            cout << " " << endl;
            cout << "---------------------------------------------" << endl;
            cout << "  Pavadinimas: " << head->name << endl
                 << "  Is viso sandelyje: " << head->number << endl
                 << "  Ar nuomojami (0-ne / 1-taip): " << head->given << endl
                 << "  Ar yra laisvu (T / N): " << head->isFree << endl 
                 << "  Buvo uzsakyta: " << head->countAll << endl; 
            cout << "---------------------------------------------" << endl;
            head = (stack*)head->next;
        }
    }
    else
        cout << "  Stekas yra tuscias\n";
}
void stack::stackDisplay(stack* head)
{
    if(head != NULL)
    {
        while ( head->next != NULL )
        {
            head = (stack*)head->next;
        }
    
        while (head != NULL)
        {
            cout << "---------------------------------------------" << endl;
            cout << "  Pavadinimas: " << head->name << endl
                 << "  Is viso sandelyje: " << head->number << endl
                 << "  Ar nuomojami (0-ne / 1-taip): " << head->given << endl
                 << "  Ar yra laisvu (T / N): " << head->isFree << endl 
                 << "  Buvo uzsakyta: " << head->countAll  << endl;
            cout << "---------------------------------------------" << endl; 
            head = (stack*)head->prev;
        }
    }
    else
        cout << "  Stekas yra tuscias\n";
}

void stack::top(stack* head)
{
    if(head != NULL)
    {
        while(head->next != NULL)
        {
            head = (stack*)head->next;
        }
        cout << "---------------------------------------------" << endl;
        cout << "  Virsutinis steko elementas: " << endl;
        cout << "---------------------------------------------" << endl;
        cout << "  Pavadinimas: " << head->name << endl; 
        cout << "  Is viso sandelyje: " << head->number << endl;
        cout << "  Ar nuomojami (0-ne / 1-taip): " << head->given << endl;
        cout << "  Ar yra laisvu (T / N): " << head->isFree << endl;
        cout << "  Buvo uzsakyta: " << head->countAll << endl;
    }
    else
        cout << "  Stekas yra tuscias\n";
}
  
stack* stack::kill(stack* head)
{
    do
    {
        head = object.pop(head);  
    }
    while(head != NULL);
    
    itemsCount = 0;
    cout << "  Stekas sekmingai istrintas!\n";    
    
    return head;
}

void stack::save()
{  
    stack* temp, *temp1;
    temp = head;
    ofstream dataFile;
    dataFile.open("data.txt");
    dataFile << itemsCount << endl;
    
    if(head != NULL)
    {
        while(head != NULL)
        {
            dataFile << head->number << " "
                     << head->given << " "
                     << head->isFree << " " 
                     << head->countAll << " "
                     << head->name << endl; 
            head = (stack*)head->next;
        }
    dataFile.close();
    }
}

stack* stack::load(stack*)
{
    string name1;
    int number1;
    bool given1;
    char isFree1;
    double countAll1;
    int itemsCount = 0;
    
    ifstream dataFile;
    dataFile.open("data.txt");
    dataFile >> itemsCount;
    
    for (int i = 0;  i < itemsCount;  i++)
    {
        dataFile >> number1 >> given1 >> isFree1 >> countAll1;
        dataFile.ignore(INT_MAX, ' ');
        getline(dataFile, name1);
        head = object.push(head, name1, number1, given1, isFree1, countAll1);  
    }
    dataFile.close();
    
    return head;
}
